<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */
/**
 * Class Mdl_Invoice_Tax_Rates
 */
class Mdl_Invoice_Tax_Rates extends Response_Model
{
    public $table = 'pd_invoice_tax_rates';
    public $primary_key = 'pd_invoice_tax_rates.invoice_tax_rate_id';

    public function default_select()
    {
        $this->db->select('pd_tax_rates.tax_rate_name AS invoice_tax_rate_name');
        $this->db->select('pd_tax_rates.tax_rate_percent AS invoice_tax_rate_percent');
        $this->db->select('pd_invoice_tax_rates.*');
    }

    public function default_join()
    {
        $this->db->join('pd_tax_rates', 'pd_tax_rates.tax_rate_id = pd_invoice_tax_rates.tax_rate_id');
    }

    /**
     * @param null $id
     * @param null $db_array
     * @return void
     */
    public function save($id = null, $db_array = null)
    {
        parent::save($id, $db_array);

        $this->load->model('invoices/mdl_invoice_amounts');

        if (isset($db_array['invoice_id'])) {
            $invoice_id = $db_array['invoice_id'];
        } else {
            $invoice_id = $this->input->post('invoice_id');
        }

        if ($invoice_id) {
            $this->mdl_invoice_amounts->calculate_invoice_taxes($invoice_id);
            $this->mdl_invoice_amounts->calculate($invoice_id);
        }

    }

    /**
     * @return array
     */
    public function validation_rules()
    {
        return array(
            'invoice_id' => array(
                'field' => 'invoice_id',
                'label' => trans('invoice'),
                'rules' => 'required'
            ),
            'tax_rate_id' => array(
                'field' => 'tax_rate_id',
                'label' => trans('tax_rate'),
                'rules' => 'required'
            ),
            'include_item_tax' => array(
                'field' => 'include_item_tax',
                'label' => trans('tax_rate_placement'),
                'rules' => 'required'
            )
        );
    }

}
